$sourceFilePath = ".\physicstaskswip.ymt"
$tempXmlFilePath = ".\physicstasks_temp.xml"
$finalFilePath = ".\physicstasks.ymt"
$lastWriteTime = Get-Item $sourceFilePath | Select-Object -ExpandProperty LastWriteTime

Write-Host "Physicstasks Cleaner started! (default format)"

# berprfen, ob die Datei physicstasksWIP.ymt existiert
if (-not (Test-Path $sourceFilePath)) {
    cls
    Write-Host "Error: Couldn't find 'physicstasksWIP.ymt'!" -ForegroundColor Red
    pause
    exit 1
}

function Remove-Comments-And-Export {
    param (
        [string]$sourceFilePath,
        [string]$tempXmlFilePath
    )

    # Datei als Text laden
    $content = Get-Content $sourceFilePath -Raw
    
    # Erste Zeile entfernen (XML-Deklaration)
    $contentWithoutFirstLine = $content -replace '^<\?xml.*\?>\s*', ''
    
    # Kommentare entfernen (Zeilen, die mit <!-- beginnen und mit --> enden)
    $contentWithoutComments = $contentWithoutFirstLine -replace '<!--.*?-->', ''
    
    # Tabulatoren durch zwei Leerzeichen ersetzen
    $contentWithoutTabs = $contentWithoutComments -replace "`t", '  '

    # UNK_MEMBER_ vor <0x und </0x hinzufgen
    $contentWithUNKMEMBER = $contentWithoutTabs -replace '<(0x\w+)', '<UNK_MEMBER_$1'
    $contentWithClosingUNKMEMBER = $contentWithUNKMEMBER -replace '</(0x\w+)', '</UNK_MEMBER_$1'

    # Bereinigten Inhalt als XML temporr speichern
    Set-Content -Path $tempXmlFilePath -Value $contentWithClosingUNKMEMBER -Encoding utf8
    
    # Versuche, den Inhalt als XML zu laden
    try {
        [xml]$xmlContent = Get-Content $tempXmlFilePath -Raw

        # Umbenennen von .xml auf .ymt
        if (Test-Path $finalFilePath) {
            Remove-Item -Path $finalFilePath -Force
        }

        # Speichern der XML-Daten im gut lesbaren Format
        $xmlWriterSettings = New-Object System.Xml.XmlWriterSettings
        $xmlWriterSettings.Indent = $true
        $xmlWriterSettings.NewLineOnAttributes = $false
        $xmlWriterSettings.Encoding = [System.Text.Encoding]::UTF8

        # XML in temporre Datei schreiben
        [System.Xml.XmlWriter]::Create($tempXmlFilePath, $xmlWriterSettings) | ForEach-Object {
            $_.WriteStartDocument()
            $xmlContent.WriteTo($_)
            $_.WriteEndDocument()
            $_.Close()
        }

        Rename-Item -Path $tempXmlFilePath -NewName $finalFilePath -Force

        # Aktuelle Uhrzeit ausgeben
        $currentTime = Get-Date -Format "HH:mm:ss"
        Write-Host "physicstasksWIP.ymt was exported to XML and renamed to physicstasks.ymt. Time: $currentTime"
    }
    catch {
        Write-Host "Error exporting XML file: $_" -ForegroundColor Red
    }
}

while ($true) {
    $currentWriteTime = Get-Item $sourceFilePath | Select-Object -ExpandProperty LastWriteTime
    if ($currentWriteTime -ne $lastWriteTime) {
        Remove-Comments-And-Export $sourceFilePath $tempXmlFilePath
        $lastWriteTime = $currentWriteTime
    }
    Start-Sleep -Seconds 2
}